<?php
session_start();

//----------------------Sezione A1------------------------//

// Connessione al database
$conn = new mysqli("localhost", "root", "", "casaeditrice_soluzione");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

//------------------------Sezione A2-------------------//


// Inizializzazione variabili
$queryResult = '';
$queryScelta = $_POST["query"] ?? '';
$titoloP = $_POST['titoloP'] ?? '';
$anno = $_POST['annoPubbl'] ?? '';
$cognome = $_POST['cognome'] ?? '';
$nome = $_POST['nome'] ?? '';
$argomento = $_POST['argomento'] ?? '';
$titoloP1 = $_POST['titoloP1'] ?? '';
$titoloP2 = $_POST['titoloP2'] ?? '';
$form = '';


//-------------Sezione A3-------------//
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Controllo quale query è stata selezionata e decido che form mostrare
    if ($queryScelta) {
        // Se la query è 'query1', mostra il form con il titoloPubbl e anno
        if ($queryScelta === 'query1') {
            $form = 'query1_form';
        }
        // Se la query è 'query2', mostra il form con il titoloPubbl
        elseif ($queryScelta === 'query2') {
            $form = 'query2_form';
        }
        // Se la query è 'query3', mostra il form con il nominativo abbonato
        elseif ($queryScelta === 'query3') {
            $form = 'query3_form';
        }
        // Se la query è 'query4', mostra il form per eseguire la query
        elseif ($queryScelta === 'query4') {
            $form = 'query4_form';
        }
        // Se la query è 'query5', non occorre il form
        elseif ($queryScelta === 'query5') {
            $form = 'execute_query';
        }
        // Se la query è 'query6', non occorre il form
        elseif ($queryScelta === 'query6') {
            $form = 'execute_query';
        }
        // Se la query è 'query7', mostra il form per i titoli di due pubblicazioni
        elseif ($queryScelta === 'query7') {
            $form = 'query7_form';
        }
        // Se la query è 'query8', mostra il form con il titoloPubbl
        elseif ($queryScelta === 'query8') {
            $form = 'query8_form';
        }
    }
}

//--------------A4----------------//
    switch ($queryScelta) {
        case 'query1':
            // Query 1: Dato il titolo di una pubblicazione, ricercare gli articoli pubblicati in un determinato anno
            $querySQL = "SELECT A.codA, A.titolo_articolo, A.annoPubbl
                        FROM Articolo A
                        JOIN Pubblicazione P ON A.codPubblil = P.codPubblil
                        WHERE P.TitoloP = ? AND A.annoPubbl = ?";
            break;
        case 'query2':
            // Query 2: Dato il titolo di una pubblicazione, ricercare gli abbonati annuali
            $querySQL = "SELECT A.cognome, A.nome 
                        FROM Abbonato A
                        JOIN Abbonamento B ON A.codAbb = B.codAbbonato
                        JOIN Pubblicazione P ON B.codPubblil = P.codPubblil
                        WHERE P.TitoloP = ? AND B.periodicita = 'Annuale'";
            break;
        case 'query3':
            // Query 3: Dato il nominativo di un abbonato, stabilire a quante riviste è abbonato
            $querySQL = "SELECT COUNT(DISTINCT P.codPubblil) AS numero_riviste
                        FROM Abbonato A
                        JOIN Abbonamento B ON A.codAbb = B.codAbbonato
                        JOIN Pubblicazione P ON B.codPubblil = P.codPubblil
                        WHERE A.cognome = ? AND A.nome = ?";
            break;
        case 'query4':
            // Query 4: Dato un argomento, elencare le pubblicazioni in cui è trattato
            $querySQL = "SELECT DISTINCT P.TitoloP
                        FROM Pubblicazione P
                        JOIN Argomento Ar ON P.codPubblil = Ar.codPubblil
                        WHERE Ar.descrizione = ?";
            break;
        case 'query5':
            // Query 5: Riportare per ogni pubblicazione il numero di abbonamenti
            $querySQL = "SELECT P.TitoloP, COUNT(B.codAbbonamento) AS numero_abbonamenti
                        FROM Pubblicazione P
                        LEFT JOIN Abbonamento B ON P.codPubblil = B.codPubblil
                        GROUP BY P.codPubblil";
            break;
        case 'query6':
            // Query 6: Visualizzare i giornali con almeno 2 abbonati annuali
            $querySQL = "SELECT P.TitoloP
                        FROM Pubblicazione P
                        JOIN Abbonamento B ON P.codPubblil = B.codPubblil
                        WHERE B.periodicita = 'Annuale'
                        GROUP BY P.codPubblil
                        HAVING COUNT(B.codAbbonamento) >= 2";
            break;
        case 'query7':
            // Query 7: Dati i titoli di due pubblicazioni, visualizzarne gli abbonati comuni
            $querySQL = "SELECT A.cognome, A.nome, A.username
                        FROM Abbonato A
                        JOIN Abbonamento B1 ON A.codAbb = B1.codAbbonato
                        JOIN Pubblicazione P1 ON B1.codPubblil = P1.codPubblil
                        JOIN Abbonamento B2 ON A.codAbb = B2.codAbbonato
                        JOIN Pubblicazione P2 ON B2.codPubblil = P2.codPubblil
                        WHERE P1.TitoloP = ? AND P2.TitoloP = ?
                        ";
            break;
        case 'query8':
            // Query 8: Dato il titolo di una pubblicazione, elencare le pubblicazioni che trattano i suoi stessi argomenti
            $querySQL = "SELECT DISTINCT P2.TitoloP
                        FROM Pubblicazione P1
                        JOIN Argomento Ar1 ON P1.codPubblil = Ar1.codPubblil
                        JOIN Argomento Ar2 ON Ar1.descrizione = Ar2.descrizione
                        JOIN Pubblicazione P2 ON Ar2.codPubblil = P2.codPubblil
                        WHERE P1.TitoloP = ? AND P2.TitoloP != P1.TitoloP";
            break;
    }

    //---------------A5----------------//
    if (isset($querySQL)) {
        $stmt = $conn->prepare($querySQL);
        if ($queryScelta == 'query1') {            
            $stmt->bind_param("ss", $titoloP, $anno);
        } elseif ($queryScelta == 'query2') {
            $stmt->bind_param("s", $titoloP);
        } elseif ($queryScelta === 'query3') {
            if(isset($_POST['abbonato'])){
                list($cognome, $nome) = explode(",", $_POST['abbonato']);
              }  // Separazione cognome e nome
            $stmt->bind_param("ss", $cognome,$nome);                   
        }elseif ($queryScelta === 'query4') {
            $stmt->bind_param("s", $argomento);                   
        }elseif ($queryScelta === 'query7') {  
            $stmt->bind_param("ss", $titoloP1, $titoloP2);                
        }elseif ($queryScelta === 'query8') {  
            $stmt->bind_param("s", $titoloP);                
        }

        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $queryResult = '<table border="1"><tr>';
            while ($field = $result->fetch_field()) {
                $queryResult .= "<th>{$field->name}</th>";
            }
            $queryResult .= '</tr>';
            while ($row = $result->fetch_assoc()) {
                $queryResult .= '<tr>';
                foreach ($row as $column) {
                    $queryResult .= "<td>{$column}</td>";
                }
                $queryResult .= '</tr>';
            }
            $queryResult .= '</table>';
        } else {
            $queryResult = 'Nessun risultato trovato.';
        }
        $stmt->close();
    }



?>

<!---------------------A6------------------>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Casa Editrice</title>
    <link rel="stylesheet" href="stile2.css">
</head>
<body>
    <div class="sidebar">
        <form method="POST" action="landing_page.php">
            <button type="submit" name="query" value="query1">Query 1</button>
            <button type="submit" name="query" value="query2">Query 2</button>
            <button type="submit" name="query" value="query3">Query 3</button>
            <button type="submit" name="query" value="query4">Query 4</button>
            <button type="submit" name="query" value="query5">Query 5</button>
            <button type="submit" name="query" value="query6">Query 6</button>
            <button type="submit" name="query" value="query7">Query 7</button>
            <button type="submit" name="query" value="query8">Query 8</button>
        </form>
        
<!---------------A7----------------->        
<?php if ($form === 'query1_form'): ?>
    <h3>Seleziona un titolo di pubblicazione e anno:</h3>
    <form method="POST" action="landing_page.php">
        <input type="hidden" name="query" value="query1">
        <label for="titoloP">Titolo pubblicazione:</label>
        <select name="titoloP" id="titoloP">
            <?php
                // Recupera i titoli di pubblicazione dal database
                $result = $conn->query("SELECT TitoloP FROM Pubblicazione");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['TitoloP'] . "'>" . $row['TitoloP'] . "</option>";
                }
            ?>
        </select>
        <br>
        <label for="annoPubbl">Anno:</label>
        <select name="annoPubbl" id="annoPubbl">
            <?php
                // Recupera gli anni disponibili dalle pubblicazioni
                $result = $conn->query("SELECT DISTINCT annoPubbl FROM Articolo");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['annoPubbl'] . "'>" . $row['annoPubbl'] . "</option>";
                }
            ?>
        </select>
        <br>
        <button type="submit">Esegui</button>
    </form>
<?php endif; ?>

<?php if ($form === 'query2_form'): ?>
    <h3>Seleziona un titolo di pubblicazione:</h3>
    <form method="POST" action="landing_page.php">
        <input type="hidden" name="query" value="query2">
        <label for="titolo_pub">Titolo pubblicazione:</label>
        <select name="titoloP" id="titolo_pub">
            <?php
                // Recupera i titoli di pubblicazione dal database
                $result = $conn->query("SELECT TitoloP FROM Pubblicazione");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['TitoloP'] . "'>" . $row['TitoloP'] . "</option>";
                }
            ?>
        </select>
        <br>
        <button type="submit">Esegui</button>
    </form>
<?php endif; ?>

<?php if ($form === 'query3_form'): ?>
    <h3>Seleziona il nominativo dell'abbonato:</h3>
    <form method="POST" action="landing_page.php">
        <input type="hidden" name="query" value="query3">
        <label for="cognome">Cognome:</label>
        <select name="abbonato" id="abbonato">
            <?php
                // Recupera i cognomi e i nomi degli abbonati combinati come "cognome nome"
                $result = $conn->query("SELECT DISTINCT cognome, nome FROM Abbonato");
                while ($row = $result->fetch_assoc()) {
                    $abbonatoDisplay = $row['cognome'] . ' ' . $row['nome'];  // Concatenazione del cognome e del nome
                    echo "<option value='" . $row['cognome'] . "," . $row['nome'] . "'>" . $abbonatoDisplay . "</option>";
                }
            ?>
        </select>
        <br>
        <button type="submit">Esegui</button>
    </form>
<?php endif; ?>

<?php if ($form === 'query4_form'): ?>
    <h3>Seleziona l'argomento:</h3>
    <form method="POST" action="landing_page.php">
        <input type="hidden" name="query" value="query4">
        <label for="argomento">Argomento:</label>
        <select name="argomento" id="argomento">
            <?php
                // Recupera i cognomi e i nomi degli abbonati combinati come "cognome nome"
                $result = $conn->query("SELECT descrizione FROM Argomento");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['descrizione'] . "'>" . $row['descrizione'] . "</option>";
                }
            ?>
        </select>
        <br>
        <button type="submit">Esegui</button>
    </form>
<?php endif; ?>

<?php if ($form === 'query7_form'): ?>
    <h3>Seleziona i titoli di due pubblicazioni:</h3>
    <form method="POST" action="landing_page.php">
        <input type="hidden" name="query" value="query7">
        
        <label for="titoloP1">Titolo prima pubblicazione:</label>
        <select name="titoloP1" id="titoloP1">
            <?php
                // Recupera i titoli di pubblicazione dal database
                $result = $conn->query("SELECT TitoloP FROM Pubblicazione");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['TitoloP'] . "'>" . $row['TitoloP'] . "</option>";
                }
            ?>
        </select>
        <br>

        <label for="titoloP2">Titolo seconda pubblicazione:</label>
        <select name="titoloP2" id="titoloP2">
            <?php
                // Recupera di nuovo i titoli di pubblicazione dal database
                $result = $conn->query("SELECT TitoloP FROM Pubblicazione");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['TitoloP'] . "'>" . $row['TitoloP'] . "</option>";
                }
            ?>
        </select>
        <br>

        <button type="submit">Esegui</button>
    </form>
<?php endif; ?>

<?php if ($form === 'query8_form'): ?>
    <h3>Seleziona un titolo di pubblicazione:</h3>
    <form method="POST" action="landing_page.php">
        <input type="hidden" name="query" value="query8">
        
        <label for="titoloP">Titolo pubblicazione:</label>
        <select name="titoloP" id="titoloP">
            <?php
                // Recupera i titoli di pubblicazione dal database
                $result = $conn->query("SELECT TitoloP FROM Pubblicazione");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['TitoloP'] . "'>" . $row['TitoloP'] . "</option>";
                }
            ?>
        </select>
        <br>

        <button type="submit">Esegui</button>
    </form>
<?php endif; ?>



    </div>

    <div class="content">
        <a href="logout.php" class="btn">LOGOUT</a>
        <h1>Benvenuto <?php echo htmlspecialchars($_SESSION["username"]); ?> nella home page della Casa Editrice!</h1>
        <h2>Seleziona una query per visualizzare i risultati</h2>
        <h3>Query 1: Dato il titolo di una pubblicazione, ricercare gli articoli pubblicati in un determinato anno.</h3>
        <h3>Query 2: Dato il titolo di una pubblicazione, ricercare gli abbonati annuali.</h3>
        <h3>Query 3: Dato il nominativo di un abbonato, stabilire a quante riviste è abbonato.</h3>
        <h3>Query 4: Dato un argomento, elencare le pubblicazioni in cui è trattato.</h3>
        <h3>Query 5: Riportare per ogni pubblicazione il numero di abbonamenti.</h3>
        <h3>Query 6: Visualizzare i giornali con almeno 5000 abbonati annuali.</h3>
        <h3>Query 7: Dati i titoli di due pubblicazioni, visualizzarne gli abbonati comuni.</h3>
        <h3>Query 8: Dato il titolo di una pubblicazione, elencare le pubblicazioni che trattano i suoi stessi argomenti.</h3>
        <!-- Visualizziamo il risultato della query -->
        <div>
            <?php echo $queryResult; ?>
        </div>
    </div>
</body>
</html>
