<?php
// Avviamo una sessione per mantenere informazioni come il nome utente o il ruolo.
session_start(); 

// Includiamo il file per la connessione al database
require_once "connessione.php"; 

if ($_SERVER["REQUEST_METHOD"] == "POST") { // Verifichiamo che il metodo della richiesta è POST e acquisiamo i dati di login inseriti dall'utente.
    $username = $_POST["username"]; 
    $password = $_POST["password"];   

    // Controlliamo se la connessione al database è valida, altrimenti terminiamo il processo.
    if (!$conn) { 
        die("Errore di connessione: " . mysqli_connect_error()); 
    }     

    // Controlliamo l'utente: query SQL per verificare se esiste un utente con il nome utente fornito.
    $sql = "SELECT id, username, password, ruolo FROM utenti WHERE username = ?"; 

    // Prepariamo e associamo il parametro per evitare SQL injection.
    $stmt = mysqli_prepare($conn, $sql); 
    $stmt->bind_param( "s", $username); 

    // Eseguiamo la query e ottieniamo il risultato.
    $stmt->execute(); 
    $result = $stmt->get_result();
    

    if ($row = $result->fetch_assoc()) { 
        if (password_verify($password, $row["password"])) { 
            // Verifichiamo che la password inserita dall'utente corrisponda alla password memorizzata
            $_SESSION["username"] = $row["username"]; 
            $_SESSION["ruolo"] = $row["ruolo"]; 
            if ($_SESSION["ruolo"]== "admin"){
                // Autenticazione riuscita: salviamo le informazioni nella sessione e reindirizziamo alla pagina di destinazione
            header("Location: home_admin.php"); 
            exit();
            }else{
                // Messaggio di errore se l'utente non ha i privilegi di accesso
                $error = "Non sei amministratore!";
            }             
        } else { 
            // Messaggio di errore se la password non è corretta
            $error = "Password errata.";              
        } 
    } else { 
        // Messaggio di errore se il nome utente non esiste nel database
        $error = "Utente non trovato.";          
    }
    // Chiude lo statement e la connessione per evitare problemi di risorse.
    $stmt->close();
    $conn->close();     
}
?>
<!DOCTYPE html> 
<html lang="it"> 
<head> 
    <meta charset="UTF-8"> 
    <title>Login</title>     
    <!-- link al foglio di stile CSS per il design -->
    <link rel="stylesheet" href="stile.css"> 
</head> 
<body> 
    <div class="container"> 
        <h2>Login</h2> 
        <!-- Visualizza un messaggio di errore, se presente, in rosso -->
        <?php if (!empty($error)) echo "<p style='color: red;'>$error</p>"; ?> 
            <form method="POST" action=""> 
                <!-- Campo per inserire il nome utente -->
                <label for="username">Username:</label> 
                <input type="text" id="username" name="username" required>           

                <br> 
                <!-- Campo per inserire la password -->
                <label for="password">Password:</label> 
                <input type="password" id="password" name="password" required>            

                <br> 
                <!-- Pulsante per inviare il form -->
                <button type="submit">Accedi</button> 
                
            </form> 
        <!-- Link per la pagina di registrazione -->
        <a href="registrazione.php" class="btn">Registrati</a> 
        
    </div> 
</body> 
</html>