<?php
session_start();

//----------------------Sezione A1------------------------//
// Controlliamo se l'utente è loggato e ha il ruolo di admin
if (!isset($_SESSION["username"]) || $_SESSION["ruolo"] != 'admin') {
    header("Location: login.php");
    exit();
}

// Connessione al database
$conn = new mysqli("localhost", "root", "", "consorzio_formaggi");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

//------------------------Sezione A2-------------------//

// Inizializzazione variabili
$queryResult = '';
$queryScelta = $_POST["query"] ?? '';
$dataInizio = $_POST["data_inizio"] ?? '';
$dataFine = $_POST["data_fine"] ?? '';
$anno = $_POST["anno"] ?? ''; 
$step = '';

//-------------Sezione A3-------------//
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if ($queryScelta && !$dataInizio && !$dataFine && !$anno) {
        if (in_array($queryScelta, ['query1', 'query4'])) {
            $step = 'date_form';
        } elseif (in_array($queryScelta, ['query2', 'query3'])) {
            $step = 'year_form';
        } else {
            $step = 'execute_query';
        }
    } elseif ($queryScelta && $dataInizio && $dataFine) {
        $step = 'execute_query';
    } elseif ($queryScelta && $anno) {
        $step = 'execute_query';
    } 
}

//--------------A4----------------//
if ($step === 'execute_query') {
    switch ($queryScelta) {
        case 'query1':
            $querySQL = "SELECT c.nome, SUM(p.forme_prodotte) AS forme_prodotte
                         FROM caseificio c
                         JOIN produzione p ON c.id = p.caseificio_id
                         WHERE p.data BETWEEN '$dataInizio' AND '$dataFine'
                         GROUP BY c.id";
            break;
        case 'query2':
            $querySQL = "SELECT c.provincia, AVG(p.latte_lavorato) AS media_latte
                         FROM caseificio c
                         JOIN produzione p ON c.id = p.caseificio_id
                         WHERE YEAR(p.data) = '$anno'
                         GROUP BY c.provincia";
            break;
        case 'query3':
            $querySQL = "SELECT c.*, SUM(v.forme_vendute) AS totale_forme
                        FROM caseificio c
                        JOIN vendite v ON c.id = v.caseificio_id
                        WHERE v.scelta = 'prima' AND YEAR(v.data_vendita) = '$anno'
                        GROUP BY c.id
                        ORDER BY totale_forme DESC
                        LIMIT 1;
                        ";
            break;
        case 'query4':
            $querySQL = "SELECT c.*, SUM(v.forme_vendute) AS totale_forme_seconda_scelta
                        FROM caseificio c
                        JOIN vendite v ON c.id = v.caseificio_id
                        WHERE v.scelta = 'seconda' AND v.data_vendita BETWEEN '$dataInizio' AND '$dataFine'
                        GROUP BY c.id
                        HAVING totale_forme_seconda_scelta < 10";
            break;
    }

    //---------------A5----------------//
    if (isset($querySQL)) {
        $result = $conn->query($querySQL);
        if ($result->num_rows > 0) {
            $queryResult = '<table border="1"><tr>';
            while ($field = $result->fetch_field()) {
                $queryResult .= "<th>{$field->name}</th>";
            }
            $queryResult .= '</tr>';
            while ($row = $result->fetch_assoc()) {
                $queryResult .= '<tr>';
                foreach ($row as $column) {
                    $queryResult .= "<td>{$column}</td>";
                }
                $queryResult .= '</tr>';
            }
            $queryResult .= '</table>';
        } else {
            $queryResult = 'Nessun risultato trovato.';
        }
    }
}
?>

<!---------------------A6------------------>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consorzio Formaggi</title>
    <link rel="stylesheet" href="stile2.css">
</head>
<body>
    <div class="sidebar">
        <form method="POST" action="home_admin.php">
            <button type="submit" name="query" value="query1">Query 1</button>
            <button type="submit" name="query" value="query2">Query 2</button>
            <button type="submit" name="query" value="query3">Query 3</button>
            <button type="submit" name="query" value="query4">Query 4</button>
        </form>
        
<!---------------A7----------------->        
        <?php if ($step === 'date_form'): ?>
            <h3>Seleziona un intervallo di date:</h3>
            <form method="POST" action="home_admin.php">
                <input type="hidden" name="query" value="<?php echo $queryScelta; ?>">
                <label for="data_inizio">Data Inizio:</label>
                <input type="date" id="data_inizio" name="data_inizio" required>
                <label for="data_fine">Data Fine:</label>
                <input type="date" id="data_fine" name="data_fine" required>
                <button type="submit">Esegui</button>
            </form>
        <?php elseif ($step === 'year_form'): ?>
            <h3>Seleziona l'anno:</h3>
            <form method="POST" action="home_admin.php">
                <input type="hidden" name="query" value="<?php echo $queryScelta; ?>">
                <label for="anno">Anno:</label>
                <input type="number" id="anno" name="anno" required>
                <button type="submit">Esegui</button>
            </form>
        <?php endif; ?>
    </div>

    <div class="content">
        <a href="logout.php" class="btn">LOGOUT</a>
        <h1>Benvenuto amministratore, <?php echo htmlspecialchars($_SESSION["username"]); ?> nella home page del Consorzio Formaggi!</h1>
        <h2>Seleziona una query per visualizzare i risultati</h2>
        <h3>Query 1: Visualizzare il numero di forme prodotte da ciascun caseificio tra due date fornite</h3>
        <h3>Query 2: Visualizzare la media del latte lavorato giornalmente nell’anno corrente dai caseifici provincia per provincia</h3>
        <h3>Query 3: Visualizzare i dati del caseificio che ha venduto il maggior numero di forme di prima scelta in un anno impostato dall’utente</h3>
        <h3>Query 4: Visualizzare l’elenco dei caseifici che, in un certo periodo individuato da due date fornite dall’utente, hanno venduto meno di 10 forme di seconda scelta</h3>

        <!-- Visualizziamo il risultato della query -->
        <div>
            <?php echo $queryResult; ?>
        </div>
    </div>
</body>
</html>

<?php
$conn->close();
?>
