<?php
// Importiamo il file per la connessione al database.
require 'connessione.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {//Verifichiamo che il metodo della richiesta è POST e acquisiamo i dati di registrazione inseriti dall'utente.
    $username = $_POST["username"];
    $password = password_hash($_POST["password"], PASSWORD_DEFAULT);// Hash della password per garantire una maggiore sicurezza. PASSWORD_DEFAULT utilizza l'algoritmo bcrypt
    
    // Impostiamo il ruolo predefinito come "utente normale".
    $ruolo = 'user';     

    // Controlliamo se lo username è già in uso
    $checkUser = $conn->prepare("SELECT id FROM utenti WHERE username = ?");

    // Prepariamo la query per evitare SQL injection 
    $checkUser->bind_param("s", $username);

    //Eseguiamo la query e memorizziamo i risultati
    $checkUser->execute();
    $checkUser->store_result(); 

    if ($checkUser->num_rows > 0) {//Se lo username è già in uso
        // Notifichiamo all'utente che il nome utente è già stato scelto da qualcun altro.
        echo "Errore: Username già in uso.";        
    } else {
        // Inserimento nuovo utente
        // Prepariamo una query per inserire l'utente nel database e leghiamo i parametri: username, password e ruolo.
        $stmt = $conn->prepare("INSERT INTO utenti (username, password, ruolo) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $username, $password, $ruolo);        

        if ($stmt->execute()) {// Se la query è stata eseguita con successo, confermiamolo all'utente e forniamo un link al login.
            echo "Registrazione completata con successo! <a href='login.php'>Vai al login</a>";            
        } else {// Mostriamo un messaggio di errore specifico
            echo "Errore: " . $stmt->error;            
        }
        $stmt->close();// Chiudiamo lo statement per liberare risorse.
    }
    // Chiudiamo sia lo statement di verifica esistenza username che la connessione al database.
    $checkUser->close();
    $conn->close();    
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Registrazione</title>
    <!-- colleghiamo il foglio di stile per il design -->
    <link rel="stylesheet" href="stile.css">    
</head>
<body>
    <div class="container">
        <h2>Registrazione</h2>
        <form method="POST">
            <!-- Campo obbligatorio per inserire lo username -->
            <label>Username:</label>
            <input type="text" name="username" required>        

            <br>
            <!-- Campo obbligatorio per inserire la password -->
            <label>Password:</label>
            <input type="password" name="password" required>        

            <br>
            <!-- Pulsante per inviare il modulo -->
            <button type="submit">Registrati</button>       
        </form>
    </div>
</body>
</html>