<?php
class Carrello {
    // Proprietà per memorizzare gli articoli e la quantità
    private $articoli = [];
    private $quantita = [];

    // Metodo per aggiungere un articolo al carrello
    public function aggiungiArticolo($nomeArticolo, $quantita) {
        // Se l'articolo esiste già, aggiorniamo la quantità
        if (isset($this->quantita[$nomeArticolo])) {
            $this->quantita[$nomeArticolo] += $quantita;
        } else {
            // Altrimenti, aggiungiamo l'articolo e la quantità
            $this->articoli[] = $nomeArticolo;
            $this->quantita[$nomeArticolo] = $quantita;
        }
    }

    // Metodo per rimuovere un articolo dal carrello
    public function rimuoviArticolo($nomeArticolo) {
        if (isset($this->quantita[$nomeArticolo])) {
            unset($this->quantita[$nomeArticolo]);
            $this->articoli = array_diff($this->articoli, [$nomeArticolo]);
        }
    }

    // Metodo per visualizzare il contenuto del carrello
    public function mostraCarrello() {
        echo "Contenuto del carrello:\n";
        foreach ($this->quantita as $articolo => $qta) {
            echo "- $articolo: $qta\n";
        }
    }
}

// Esempio di utilizzo della classe
$carrello = new Carrello();
$carrello->aggiungiArticolo("Mela", 3);
$carrello->aggiungiArticolo("Pane", 2);
$carrello->aggiungiArticolo("Mela", 1); // Aggiunge altre 1 mela
$carrello->rimuoviArticolo("Pane");
$carrello->mostraCarrello(); //ho aggiunto 3 mele, 2 pane, 1 mela e ho rimosso 2 pane quindi visualizzerò: 4 mele

?>