<?php
/*Inizializzazione della sessione:

    Creare un file index.php che inizializza la sessione.
    Assegnare un valore di default alla variabile di sessione user (ad esempio, "Ospite").
    Contare il numero di visite usando una variabile di sessione visits.
    Mostrare il messaggio di benvenuto e il numero di visite.

Aggiornamento dell'utente:

    Crea un file update_user.php.
    All'interno di questo file, modifica dinamicamente il valore della variabile di sessione user (ad esempio, "Nuovo Utente").
    Reindirizza l'utente alla pagina principale (index.php).

Pulsante di aggiornamento:

    Nella pagina principale (index.php), aggiungere un link o un pulsante che reindirizza l'utente alla pagina update_user.php per l'aggiornamento dell'utente.

Stile e presentazione:

    Migliorare l'aspetto delle pagine utilizzando il CSS per la formattazione e la presentazione.
    Aggiungere stili per evidenziare il messaggio di benvenuto e il numero di visite.

Altre informazioni di sessione:

    Sperimentare con l'aggiunta di altre informazioni nella sessione, come un carrello della spesa o preferenze utente.
    Modificare la pagina principale per visualizzare e gestire queste nuove informazioni di sessione.

Spiegazione:
In questa esercitazione guidata, la pagina principale (index.php) inizializza la sessione, assegnando un valore di default all'utente (in questo caso, "Ospite") e tiene traccia del numero di visite.
La pagina update_user.php mostra come si può modificare dinamicamente i dati della sessione. 
In questo caso, modifica il valore dell'utente e poi reindirizza l'utente alla pagina principale (index.php).*/
?>

<?php
session_start();

// Imposta un valore di default per l'utente se non esiste
if (!isset($_SESSION['utente'])) {
    $_SESSION['utente'] = "Ospite";
}

// Conta il numero di visite
if (!isset($_SESSION['visits'])) {
    $_SESSION['visits'] = 1;
} else {
    $_SESSION['visits']++;
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Gestione Sessione</title>
    <link rel="stylesheet" href="stile.css">
</head>
<body>
    <div class="container">
        <h1>Benvenuto, <?php echo $_SESSION['utente']; ?>!</h1>
        <p>Numero di visite <?php echo $_SESSION['visits']; ?></p>
        <a href="update_user.php" class="btn">Aggiorna Utente</a>
    </div>
</body>
</html>
