##
#  This program computes income taxes, using a simplified tax schedule.
#

# Initialize constant variables for the tax rates and rate limits.
RATE1 = 0.10
RATE2 = 0.25
RATE1_SINGLE_LIMIT = 32000.0
RATE1_MARRIED_LIMIT = 64000.0

# Read income and marital status     
income = float(input("Please enter your income: "))
marital_status = input("Please enter s for single, m for married: ")

# Compute taxes due.
tax1 = 0
tax2 = 0

if marital_status == "s":
    if income <= RATE1_SINGLE_LIMIT:
        tax1 = RATE1 * income
    else:
        tax1 = RATE1 * RATE1_SINGLE_LIMIT
        tax2 = RATE2 * (income - RATE1_SINGLE_LIMIT)
else:
    if income <= RATE1_MARRIED_LIMIT:
        tax1 = RATE1 * income
    else:
        tax1 = RATE1 * RATE1_MARRIED_LIMIT
        tax2 = RATE2 * (income - RATE1_MARRIED_LIMIT)

total_tax = tax1 + tax2

# Print the results.
print("The tax is $%.2f" % total_tax)
