<?php
// Header comuni
include 'connessione.php';
include_once 'header.php';

// Ottieni il metodo HTTP
$method = $_SERVER['REQUEST_METHOD'];

// Leggi il corpo della richiesta
$input = json_decode(file_get_contents("php://input"), true);

switch ($method) {

    case 'GET':
        $sql = "SELECT * FROM utenti";
        $result = mysqli_query($conn, $sql);
        $rubrica = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $rubrica[] = $row;
        }

        echo json_encode(["records" => $rubrica]);
        break;

    case 'POST':
        if (!empty($input['cognome']) && !empty($input['nome'])) {
            $cognome   = mysqli_real_escape_string($conn, $input['cognome']);
            $nome      = mysqli_real_escape_string($conn, $input['nome']);
            $email     = mysqli_real_escape_string($conn, $input['email'] ?? '');
            $via       = mysqli_real_escape_string($conn, $input['via'] ?? '');
            $citta     = mysqli_real_escape_string($conn, $input['citta'] ?? '');
            $provincia = mysqli_real_escape_string($conn, $input['provincia'] ?? '');
            $cap       = mysqli_real_escape_string($conn, $input['cap'] ?? '');
            $telefono  = mysqli_real_escape_string($conn, $input['telefono'] ?? '');

            $sql = "INSERT INTO utenti (cognome, nome, email, via, citta, provincia, cap, telefono)
                    VALUES ('$cognome', '$nome', '$email', '$via', '$citta', '$provincia', '$cap', '$telefono')";

            if (mysqli_query($conn, $sql)) {
                echo json_encode(["message" => "Contatto inserito con successo."]);
            } else {
                echo json_encode(["message" => "Errore durante l'inserimento."]);
            }
        } else {
            echo json_encode(["message" => "Dati obbligatori mancanti."]);
        }
        break;

    case 'PUT':
        if (!empty($input['id'])) {
            $id = intval($input['id']);
            $updates = [];

            foreach (['cognome', 'nome', 'email', 'via', 'citta', 'provincia', 'cap', 'telefono'] as $field) {
                if (isset($input[$field])) {
                    $value = mysqli_real_escape_string($conn, $input[$field]);
                    $updates[] = "$field = '$value'";
                }
            }

            if (!empty($updates)) {
                $sql = "UPDATE utenti SET " . implode(", ", $updates) . " WHERE id = $id";
                if (mysqli_query($conn, $sql)) {
                    echo json_encode(["message" => "Contatto aggiornato con successo."]);
                } else {
                    echo json_encode(["message" => "Errore durante l'aggiornamento."]);
                }
            } else {
                echo json_encode(["message" => "Nessun campo da aggiornare."]);
            }
        } else {
            echo json_encode(["message" => "ID non fornito."]);
        }
        break;

    case 'DELETE':
        if (!empty($input['id'])) {
            $id = intval($input['id']);
            $sql = "DELETE FROM utenti WHERE id = $id";

            if (mysqli_query($conn, $sql)) {
                echo json_encode(["message" => "Contatto eliminato con successo."]);
            } else {
                echo json_encode(["message" => "Errore durante l'eliminazione."]);
            }
        } else {
            echo json_encode(["message" => "ID non fornito."]);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(["message" => "Metodo non consentito."]);
        break;
}

mysqli_close($conn);
?>