<?php
// Includi header comuni
include_once 'header.php';

// Includi il file per la connessione al database
include_once 'connessione.php';

// Classe per la gestione delle operazioni sulla rubrica
class Rubrica {
    private $conn;
    private $table_name = "utenti";

    // Proprietà degli utenti
    public $id;
    public $cognome;
    public $nome;
    public $email;
    public $via;
    public $citta;
    public $provincia;
    public $cap;
    public $telefono;

    // Costruttore con connessione
    public function __construct($db) {
        $this->conn = $db;
    }

    // Metodo per leggere tutti gli utenti
    public function read() {
        $query = "SELECT * FROM " . $this->table_name;
        $stmt = $this->conn->query($query);
        return $stmt;
    }

    // Metodo per creare un nuovo utente
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  (cognome, nome, email, via, citta, provincia, cap, telefono)
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->conn->prepare($query);

        $stmt->bind_param("ssssssss", $this->cognome, $this->nome, $this->email, $this->via, 
            $this->citta, $this->provincia, $this->cap, $this->telefono);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Metodo per aggiornare un utente
    public function update() {
        $query = "UPDATE " . $this->table_name . " 
                  SET cognome = ?, nome = ?, email = ?, via = ?, citta = ?, provincia = ?, cap = ?, telefono = ? 
                  WHERE id = ?";
        $stmt = $this->conn->prepare($query);

        $stmt->bind_param("ssssssssi", $this->cognome, $this->nome, $this->email, $this->via, 
            $this->citta, $this->provincia, $this->cap, $this->telefono, $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Metodo per eliminare un utente
    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);

        $stmt->bind_param("i", $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
}

// Creazione connessione
$database = new Database();
$db = $database->getConnection();

// Creazione istanza della classe Rubrica
$rubrica = new Rubrica($db);

// Ottieni il metodo della richiesta
$method = $_SERVER['REQUEST_METHOD'];

// Decodifica il contenuto JSON
$data = json_decode(file_get_contents("php://input"), true);

// Routing per i metodi REST
switch ($method) {
    case 'GET':
        $stmt = $rubrica->read();
        if ($stmt->num_rows > 0) {
            $utenti = array();
            $utenti["records"] = array();

            while ($row = $stmt->fetch_assoc()) {
                $utenti["records"][] = $row;
            }
            echo json_encode($utenti);
        } else {
            echo json_encode(["message" => "Nessun utente trovato."]);
        }
        break;

    case 'POST':
        if (!empty($data["cognome"]) && !empty($data["nome"])) {
            $rubrica->cognome = $data["cognome"];
            $rubrica->nome = $data["nome"];
            $rubrica->email = $data["email"] ?? '';
            $rubrica->via = $data["via"] ?? '';
            $rubrica->citta = $data["citta"] ?? '';
            $rubrica->provincia = $data["provincia"] ?? '';
            $rubrica->cap = $data["cap"] ?? '';
            $rubrica->telefono = $data["telefono"] ?? '';

            if ($rubrica->create()) {
                echo json_encode(["message" => "Utente inserito con successo."]);
            } else {
                echo json_encode(["message" => "Errore durante l'inserimento."]);
            }
        } else {
            echo json_encode(["message" => "Dati incompleti."]);
        }
        break;

    case 'PUT':
        if (!empty($data["id"])) {
            $rubrica->id = $data["id"];
            $rubrica->cognome = $data["cognome"] ?? '';
            $rubrica->nome = $data["nome"] ?? '';
            $rubrica->email = $data["email"] ?? '';
            $rubrica->via = $data["via"] ?? '';
            $rubrica->citta = $data["citta"] ?? '';
            $rubrica->provincia = $data["provincia"] ?? '';
            $rubrica->cap = $data["cap"] ?? '';
            $rubrica->telefono = $data["telefono"] ?? '';

            if ($rubrica->update()) {
                echo json_encode(["message" => "Utente aggiornato con successo."]);
            } else {
                echo json_encode(["message" => "Errore durante l'aggiornamento."]);
            }
        } else {
            echo json_encode(["message" => "ID non specificato."]);
        }
        break;

    case 'DELETE':
        if (!empty($data["id"])) {
            $rubrica->id = $data["id"];
            if ($rubrica->delete()) {
                echo json_encode(["message" => "Utente eliminato con successo."]);
            } else {
                echo json_encode(["message" => "Errore durante l'eliminazione."]);
            }
        } else {
            echo json_encode(["message" => "ID non specificato."]);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(["message" => "Metodo non consentito."]);
        break;
}
?>
